# -*- coding: UTF-8 -*-
# Ivan Kostadinov

import numpy as np
import os, glob, PIL, cv2, math, json, datetime
from numpy import *
from PIL   import Image
from scipy import ndimage
from scipy.ndimage import zoom
print " "
print " "

# PARAMETERS
source_dir = 'D:/art_and_work_files/workstation/_projects/Juno/production/rgb_combined_part_1/'
output_dir = 'D:/art_and_work_files/workstation/_projects/Juno/production/rgb_combined_part_1/results'
file_number = 1


#canvas
grid = np.empty(shape=(1000, 100), dtype=np.dtype('uint8'))
grid[:] = 0

# data point coordinates:
hor_initial  =  10       # zero based
vert_initial =   9  	 # zero based
step_h       =  50       # horizontal distance between two sequences
row_1        =  33       # vertical position of the RED row
row_2        = 100       # vertical position of the GREEN row
row_3        = 166       # vertical position of the BLUE row

rows         = [row_1, row_2, row_3]

# actual radius / total radius
# it limits the search radius to certain percent of the total radius
max_r = 0.9

#DEFINITIONS


def flipit(array, h, v):
	if h == 1:
		# flip horizontally
		array = np.fliplr(array)
	if v == 1:
		# flip # flip vertically
		array = np.flipud(array)
	return array
	

def calc_radius(x,y,cx,cy):
	# cx - vertical
	# cy - horizontal
	dx = x - cx
	dy = y - cy
	d = sqrt(dx**2 + dy**2)
	
	return d

def calc_luma(r, g, b):
	lum = 0.2126*r + 0.7152*g + 0.0722*b
	return int(round(lum))

def collect_raw_data(array, mask, disk_number):
	global hor_initial, rows, step_h
	mask_color = 255
	dt_rr = []
	dt_blue = []
	dt_green = []
	dt_red = []
	dt_x = []
	dt_y = []
	dt_kgb = []
	dt_krb = []
	dt_lum = []

	
	# the mask and array dimensions are the same
	# the input array is global - the whole picture
	# changing space to local only to the relevant 3 discs
	loc_1 = (disk_number-1)*step_h
	
	array_local  = array[:, loc_1:loc_1+step_h]
	mask_local   = mask[:, loc_1:loc_1+step_h]
	
	center_row_R_vert = rows[0]
	center_row_G_vert = rows[1]
	center_row_B_vert = rows[2]	
	
	# BLUE space
	blue_vert = int(round((2.0/3.0)*(array_local.shape[0])))
	array_blue = array_local[blue_vert:, :]
	mask_blue = mask_local[blue_vert:, :]
	# number of pixels 
	raw_pixels = num_non_zero_pixels = np.count_nonzero(array_blue)
	
	# RED space
	red_vert = int(round((1.0/3.0)*(array_local.shape[0])))
	array_red = array_local[:red_vert, :]
	mask_red = mask_local[:red_vert, :]

	# GREEN space
	green_vert_1 = int(round((1.0/3.0)*(array_local.shape[0])))
	green_vert_2 = int(round((2.0/3.0)*(array_local.shape[0])))
	array_green = array_local[green_vert_1:green_vert_2, :]
	mask_green = mask_local[green_vert_1:green_vert_2, :]
	
	
	# extracting the 3 radius values from the white dots in the mask array
	# we obtain data for the 4 points in each disk
	tmp = np.where(mask_blue == mask_color)
	cx_blue = tmp[0][1] # along the vertical
	cy_blue = tmp[1][0]	
	rx = ((tmp[1][2] - tmp[1][1])  + (tmp[0][1] - tmp[0][0]) + (tmp[0][3] - tmp[0][1]))/3.0
	
	r_b = rx # blue radius (bottom disc)
	
	tmp = np.where(mask_green == mask_color)
	cx_green = tmp[0][1] # along the vertical
	cy_green = tmp[1][0]		
	r_g = rx # green radius (middle disc)
	
	tmp = np.where(mask_red == mask_color)
	cx_red = tmp[0][1] # along the vertical
	cy_red = tmp[1][0]		
	r_r = rx # red radius (top disc)
	
	#iterating over the blue disc
	iter = 0
	for index, value in np.ndenumerate(array_blue):
		#calculates the actual RGB disks radius from the mask array
		r = calc_radius(index[0], index[1], cx_blue, cy_blue)
		# relative radius (rr)
		rr = r*1.0/r_b
		if rr <= max_r and array_blue[index] > 0:
			# counting the number of pixels	
			# base value
			b_val = value
			# find dx and dy relative to the center of the blue disk
			dx = index[0] - cx_blue # along the vertical
			dy = index[1] - cy_blue
			# get GREEN color at the same relative distance
			# coordinates in question
			g_p_x = cx_green + dx
			g_p_y = cy_green + dy
			#value at question
			#print array_green[g_p_x, g_p_y]
			if array_green[g_p_x, g_p_y] > 0:
				g_val = array_green[g_p_x, g_p_y]
			
			# get RED color at the same relative distance
			# coordinates in question
			r_p_x = cx_red + dx
			r_p_y = cy_red + dy
			#value at question
			if array_red[r_p_x, r_p_y] > 0:
				r_val = array_red[r_p_x, r_p_y]	

			# get coefficients:
			# green / blue
			k_gb = g_val*1.0 / b_val
			if k_gb > 4:
				k_gb = 4
			# red / blue
			k_rb = r_val*1.0 / b_val
			if k_rb > 5:
				k_rb = 5			
			
			# calculating luma
			# https://en.wikipedia.org/wiki/Relative_luminance
			lum = 0.2126*r_val + 0.7152*g_val + 0.0722*b_val
			
			
			dt_rr.append(rr)
			dt_blue.append(b_val)
			dt_green.append(g_val)
			dt_red.append(r_val)
			dt_x.append(dx) # along the vertical
			dt_y.append(dy)
			dt_kgb.append(round(k_gb, 4))
			dt_krb.append(round(k_rb, 4))
			dt_lum.append(lum)
			
			#               0       1         2        3      4     5     6        7      8
			dt_collect = [dt_rr, dt_blue, dt_green, dt_red, dt_x, dt_y, dt_kgb, dt_krb, dt_lum]
			iter+=1

	return dt_collect




def full_color_profile():
	img          = PIL.Image.open(source_dir  + "_selected_RGB.png")
	iar          = np.array(img, dtype=np.uint8)
	img_mask          = PIL.Image.open(source_dir  + "_selected_RGB_masked.png")
	iar_mask          = np.array(img_mask, dtype=np.uint8)

	
	output_dir   = 'D:/art_and_work_files/workstation/_projects/Juno/production/rgb_combined_part_1/results/csv/'
	delimiter    = ","
	first_row    = "disc, dx, dy, relative radius, blue, green, red, green/blue, red/blue, luma \n"
	
	with file(output_dir + "full_rgb_data.csv", "w") as outfile:
		outfile.write(first_row)
		for disc in range(1, 16):
			dt_collect = collect_raw_data(iar, iar_mask, disc)
			for i in range(len(dt_collect[0])):
				outfile.write(str(disc) + delimiter + str(dt_collect[4][i]) + delimiter + str(dt_collect[5][i]) + delimiter +
							str(dt_collect[0][i]) + delimiter + str(dt_collect[1][i]) + delimiter + 
							str(dt_collect[2][i]) + delimiter + str(dt_collect[3][i]) + delimiter +
							str(dt_collect[6][i]) + delimiter + str(dt_collect[7][i]) + delimiter +
							str(dt_collect[8][i]) + "\n")
	
	#print "data is written"
	return
	


def generate_color_profile():

	data = np.genfromtxt ('full_rgb_data.csv', delimiter=",")
	data = data[1:, :]
	#         0       1   2          3             4       5      6           7          8        9
	#       disc	 dx	 dy	 relative radius	 blue	 green	 red	 green/blue	 red/blue	 luma 

			
	bb = np.arange(256)
	gg = np.empty(shape=(256), dtype=np.dtype('uint8'))
	rr = np.empty(shape=(256), dtype=np.dtype('uint8'))

	# structure:
	# [0,1,2,3,4] = 
	# [blue, green, red, k_green, k_red]  already multiplied. final values.
	profile = np.empty(shape=(256, 4), dtype=np.dtype('float'))
	profile[:] = 0
	
	sum_g = 0
	sum_r = 0
	counter = 0
	
	gg = 0
	rr = 0
	sm = 0
	for clr in range(256):
		a = [index for index,value in enumerate(data[:, 4]) if value == clr]
		if len(a) > 0:
			for u,val in enumerate(a):
				green_vals = data[val, 5]
				red_vals   = data[val, 6]
				gg +=green_vals
				rr +=red_vals
				avrg_green = int(round(gg*1.0/len(a)))
				avrg_red   = int(round(rr*1.0/len(a)))
				profile[clr, 0] = clr
				profile[clr, 1] = avrg_green
				profile[clr, 2] = avrg_red
				luma = calc_luma(avrg_red, avrg_green, clr)
				profile[clr, 3] = luma
			gg = 0
			rr = 0
			
	profile[:, 0] = np.arange(256)
	#profile = np.where(profile[1:, 0] == 0, 1, profile[:, 0])


	# CSV part
	output_dir = 'D:/art_and_work_files/workstation/_projects/Juno/production/rgb_combined_part_1/results/csv/'

	delimiter = ","
	first_row = "Blue, Green, Red, Luma \n"

	with file(output_dir + "combined_averaged_rgb_color_profile.csv", "w") as outfile:
		outfile.write(first_row)
		for i in range(256):
			#print i
			outfile.write(str(int(profile[i][0])) + delimiter +
			              str(int(profile[i][1])) + delimiter + 
						  str(int(profile[i][2])) + delimiter +
						  str(profile[i][3])      + "\n")
						  
	return profile



	
	
# CODE EXECUTION


#full_color_profile()

generate_color_profile()	

	
	
